<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Enqueue parent and child theme styles
function flairstonelending_enqueue_styles() {
    $parent_style = 'astra-style';

    wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
    wp_enqueue_style('flairstone-lending-style', get_stylesheet_directory_uri() . '/style.css', array($parent_style), wp_get_theme()->get('Version'));
}
add_action('wp_enqueue_scripts', 'flairstonelending_enqueue_styles');


// For Apply Online 

function add_custom_footer_jquery_script() {
    ?>
    <script>
    jQuery(document).ready(function(){
        jQuery(".step_1_btn").click(function(){
            jQuery(".step_2").fadeOut("400");
            jQuery(".step_3").fadeOut("400");
            jQuery(".step_1").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").addClass("active");
            jQuery(".info_li_2").removeClass("active");
            jQuery(".info_li_3").removeClass("active");
        });
        jQuery(".step_2_btn").click(function(){
            jQuery(".step_1").fadeOut("400");
            jQuery(".step_3").fadeOut("400");
            jQuery(".step_2").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").removeClass("active");
            jQuery(".info_li_2").addClass("active");
            jQuery(".info_li_3").removeClass("active");
        });
        jQuery(".step_3_btn").click(function(){
            jQuery(".step_1").fadeOut("400");
            jQuery(".step_2").fadeOut("400");
            jQuery(".step_3").delay(400).fadeIn("400").addClass("active");
            jQuery(".info_li_1").removeClass("active");
            jQuery(".info_li_2").removeClass("active");
            jQuery(".info_li_3").addClass("active");
        });
    });
    </script>
    <?php
}

add_action('wp_footer', 'add_custom_footer_jquery_script', 100);